/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.recipe.conditions;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import compasses.expandedstorage.impl.misc.Utils;
import compasses.expandedstorage.impl.recipe.conditions.RecipeCondition;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.Nullable;

public class IsInTagCondition
implements RecipeCondition {
    public static final ResourceLocation NETWORK_ID = Utils.id("in_tag");
    private final TagKey<?> tagKey;
    private Set<Object> values;

    public IsInTagCondition(TagKey<?> tagKey) {
        this.tagKey = tagKey;
    }

    @Override
    public boolean isExactMatch() {
        return false;
    }

    @Override
    public boolean test(Object subject) {
        if (this.values == null) {
            this.values = ((HolderSet.Named)((Registry)BuiltInRegistries.f_257047_.m_7745_(this.tagKey.f_203867_().m_135782_())).m_203431_(this.tagKey).orElseThrow()).m_203614_().map(Holder::m_203334_).collect(Collectors.toUnmodifiableSet());
        }
        return this.values.contains(RecipeCondition.unwrap(subject));
    }

    @Override
    public ResourceLocation getNetworkId() {
        return NETWORK_ID;
    }

    @Override
    public void writeToBuffer(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.tagKey.f_203867_().m_135782_());
        buffer.m_130085_(this.tagKey.f_203868_());
    }

    public static IsInTagCondition readFromBuffer(FriendlyByteBuf buffer) {
        ResourceLocation registryId = buffer.m_130281_();
        ResourceLocation tag = buffer.m_130281_();
        Registry registry = (Registry)BuiltInRegistries.f_257047_.m_7745_(registryId);
        if (registry == null) {
            throw new NullPointerException("Unknown registry: " + registryId);
        }
        return new IsInTagCondition(TagKey.m_203882_((ResourceKey)registry.m_123023_(), (ResourceLocation)tag));
    }

    @Override
    @Nullable
    public JsonElement toJson(@Nullable JsonObject object) {
        if (object != null) {
            this.writeToJsonObject(object);
            return null;
        }
        JsonObject jsonObject = new JsonObject();
        this.writeToJsonObject(jsonObject);
        return jsonObject;
    }

    private void writeToJsonObject(JsonObject object) {
        object.addProperty("tag", this.tagKey.f_203868_().toString());
    }
}

